/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.pathmapper;

import com.aptana.php.debug.core.server.PHPServersManager;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import com.aptana.webserver.core.ExternalWebServer;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.IServerChangeListener;
import com.aptana.webserver.core.ServerChangeEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org2.eclipse.php.debug.core.debugger.pathmapper.PathMapper;
import org2.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org2.eclipse.php.internal.core.util.preferences.XMLPreferencesReader;
import org2.eclipse.php.internal.core.util.preferences.XMLPreferencesWriter;
import org2.eclipse.php.internal.debug.core.interpreter.preferences.PHPexeItem;
import org2.eclipse.php.internal.debug.core.preferences.IPHPExesListener;
import org2.eclipse.php.internal.debug.core.preferences.PHPExesEvent;
import org2.eclipse.php.internal.debug.core.preferences.PHPexes;

public class PathMapperRegistry
implements IXMLPreferencesStorable,
IPHPExesListener,
IServerChangeListener {
    private static final String PATH_MAPPER_ATTRIBUTE = "pathMapper";
    private static final String SERVER_TYPE_ATTRIBUTE = "serverType";
    private static final String PATH_MAPPER_EXTENSION_ID = "com.aptana.php.debug.pathMapper";
    private static final String PATH_MAPPER_PREF_KEY = "com.aptana.php.debug.epl.pathMapper";
    private static PathMapperRegistry instance;
    private HashMap<IServer, PathMapper> serverPathMapper = new HashMap();
    private HashMap<PathMapper, IServer> pathMapperToServer;
    private HashMap<PHPexeItem, PathMapper> phpExePathMapper = new HashMap();

    private PathMapperRegistry() {
        this.pathMapperToServer = new HashMap();
        this.loadFromPreferences();
    }

    public static synchronized PathMapperRegistry getInstance() {
        if (instance == null) {
            instance = new PathMapperRegistry();
        }
        return instance;
    }

    public static PathMapper getByPHPExe(PHPexeItem phpExe) {
        PathMapper result = PathMapperRegistry.getInstance().phpExePathMapper.get(phpExe);
        if (result == null) {
            result = new PathMapper();
            PathMapperRegistry.getInstance().phpExePathMapper.put(phpExe, result);
            PHPexes.getInstance().addPHPExesListener(PathMapperRegistry.getInstance());
        }
        return result;
    }

    public static PathMapper getByServer(IServer server) {
        PathMapper result = PathMapperRegistry.getInstance().serverPathMapper.get(server);
        if (result == null) {
            result = PathMapperRegistry.getNewServerPathMapper(server);
            PathMapperRegistry.getInstance().serverPathMapper.put(server, result);
            PathMapperRegistry.getInstance().pathMapperToServer.put(result, server);
        }
        return result;
    }

    public static IServer getByMapper(PathMapper mapper) {
        IServer server = PathMapperRegistry.getInstance().pathMapperToServer.get(mapper);
        return server;
    }

    public static PathMapper getByLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        PathMapper pathMapper = null;
        try {
            String serverName = launchConfiguration.getAttribute("serverName", null);
            if (serverName != null) {
                pathMapper = PathMapperRegistry.getByServer(PHPServersManager.getServer((String)serverName));
            }
        }
        catch (CoreException e) {
            PHPDebugEPLPlugin.logError(e);
        }
        return pathMapper;
    }

    public void loadFromPreferences() {
        Map[] elements = XMLPreferencesReader.read((Preferences)PHPDebugEPLPlugin.getDefault().getPluginPreferences(), (String)PATH_MAPPER_PREF_KEY);
        if (elements.length == 1) {
            this.restoreFromMap(elements[0]);
        }
    }

    public static void storeToPreferences() {
        XMLPreferencesWriter.write((Preferences)PHPDebugEPLPlugin.getDefault().getPluginPreferences(), (String)PATH_MAPPER_PREF_KEY, (IXMLPreferencesStorable)PathMapperRegistry.getInstance());
    }

    public synchronized void restoreFromMap(Map map) {
        if (map == null) {
            return;
        }
        this.serverPathMapper.clear();
        this.pathMapperToServer.clear();
        this.phpExePathMapper.clear();
        map = (HashMap)map.get("pathMappers");
        if (map == null) {
            return;
        }
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            PHPexeItem phpExeItem;
            HashMap entryMap = (HashMap)map.get(i.next());
            String serverName = (String)entryMap.get("server");
            String phpExeFile = (String)entryMap.get("phpExe");
            String phpIniFile = (String)entryMap.get("phpIni");
            PathMapper pathMapper = new PathMapper();
            pathMapper.restoreFromMap((HashMap)entryMap.get("mapper"));
            if (serverName != null) {
                IServer server = PHPServersManager.getServer((String)serverName);
                if (server == null) continue;
                this.serverPathMapper.put(server, pathMapper);
                this.pathMapperToServer.put(pathMapper, server);
                continue;
            }
            if (phpExeFile == null || (phpExeItem = PHPexes.getInstance().getItemForFile(phpExeFile, phpIniFile)) == null) continue;
            this.phpExePathMapper.put(phpExeItem, pathMapper);
        }
    }

    public synchronized Map storeToMap() {
        PathMapper pathMapper;
        HashMap<String, Object> entry;
        HashMap elements = new HashMap();
        Iterator<Object> i = this.serverPathMapper.keySet().iterator();
        int c = 1;
        while (i.hasNext()) {
            entry = new HashMap<String, Object>();
            IServer server = (IServer)i.next();
            pathMapper = this.serverPathMapper.get(server);
            entry.put("server", server.getName());
            entry.put("mapper", pathMapper.storeToMap());
            elements.put("item" + c++, entry);
        }
        i = this.phpExePathMapper.keySet().iterator();
        while (i.hasNext()) {
            entry = new HashMap();
            PHPexeItem phpExeItem = (PHPexeItem)i.next();
            pathMapper = this.phpExePathMapper.get(phpExeItem);
            entry.put("phpExe", phpExeItem.getExecutable().toString());
            if (phpExeItem.getINILocation() != null) {
                entry.put("phpIni", phpExeItem.getINILocation().toString());
            }
            entry.put("mapper", pathMapper.storeToMap());
            elements.put("item" + c++, entry);
        }
        HashMap root = new HashMap();
        root.put("pathMappers", elements);
        return root;
    }

    @Override
    public void phpExeAdded(PHPExesEvent event) {
        if (!this.phpExePathMapper.containsKey(event.getPHPExeItem())) {
            this.phpExePathMapper.put(event.getPHPExeItem(), new PathMapper());
        }
    }

    @Override
    public void phpExeRemoved(PHPExesEvent event) {
        this.phpExePathMapper.remove(event.getPHPExeItem());
    }

    @Override
    public void phpExeDefaultChanged(PHPexeItem oldDefault, PHPexeItem newDefault) {
    }

    private static PathMapper getNewServerPathMapper(IServer server) {
        PathMapper pathMapper;
        block5: {
            pathMapper = new PathMapper();
            if (!server.isPersistent()) {
                return pathMapper;
            }
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(PATH_MAPPER_EXTENSION_ID);
            try {
                if (elements == null || elements.length == 0) break block5;
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    String attribute = element.getAttribute(SERVER_TYPE_ATTRIBUTE);
                    if (attribute != null && attribute.equals(server.getId())) {
                        pathMapper = (PathMapper)element.createExecutableExtension(PATH_MAPPER_ATTRIBUTE);
                        break;
                    }
                    ++n2;
                }
            }
            catch (Throwable th) {
                PHPDebugEPLPlugin.logError("Unexpected exception while getting server path mappers", th);
            }
        }
        return pathMapper;
    }

    public void configurationChanged(ServerChangeEvent event) {
        IServer server = event.getServer();
        switch (event.getKind()) {
            case ADDED: {
                if (this.serverPathMapper.containsKey(server) || !(server instanceof ExternalWebServer)) break;
                PathMapper mapper = PathMapperRegistry.getNewServerPathMapper(server);
                this.serverPathMapper.put(server, mapper);
                this.pathMapperToServer.put(mapper, server);
                break;
            }
            case REMOVED: {
                PathMapper removed = this.serverPathMapper.remove(server);
                if (removed == null) break;
                this.pathMapperToServer.remove(removed);
            }
        }
    }
}

